<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use Doctrine\Common\Annotations\AnnotationException;
use ReflectionException;
use XCart\Extender\Model\Reflection;

interface AnnotationsParserInterface
{
    /**
     * @param Reflection $reflection
     *
     * @return array
     * @throws AnnotationException
     * @throws ReflectionException
     */
    public function parseAnnotations(Reflection $reflection): array;
}
