<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use Doctrine\Common\Annotations\AnnotationException;
use Doctrine\Common\Annotations\DocParser;
use ReflectionException;
use XCart\Extender\Model\Reflection;

/**
 * @deprecated
 */
class AnnotationsParser implements AnnotationsParserInterface
{
    /**
     * @var DocParser
     */
    private DocParser $docParser;

    /**
     * @param DocParser $docParser
     *
     * @codeCoverageIgnore
     */
    public function __construct(DocParser $docParser)
    {
        $docParser->setIgnoreNotImportedAnnotations(true);
        $docParser->addNamespace('XCart\\Extender\\Mapping');
        $docParser->addNamespace('Doctrine\\ORM\\Mapping');

        $this->docParser = $docParser;
    }

    /**
     * @param Reflection $reflection
     *
     * @return array
     * @throws AnnotationException
     * @throws ReflectionException
     */
    public function parseAnnotations(Reflection $reflection): array
    {
        return $this->docParser->parse($reflection->getDocComment());
    }
}
