<?php

require_once '../vendor/autoload.php';

use Symfony\Component\Yaml\Yaml;
use XCart\Extender\Extender;

$modules = [
    'XC\Module1',
    'XC\Module2',
];

$dependencies = [];

$root    = __DIR__ . '/input/';

$sources = ['XLite' => $root . 'XLite'];

foreach (glob($root . 'XLite/Module/*/*') as $path) {
    $namespace = str_replace([$root, '/'], ['', '\\'], $path);

    [, , $author, $name] = explode('\\', $namespace);
    $module = implode('\\', [$author, $name]);

    if (in_array($module, $modules, true)) {
        $sources[$namespace] = $path;
    }

    $moduleInfo = Yaml::parse(
        file_get_contents($path . '/main.yaml')
    );

    $dependencies[$module] = $moduleInfo['dependsOn'];
}

$metaDecorator = new Extender();

$metaDecorator
    ->setSources($sources)
    ->setTargetRoot(__DIR__ . '/output/')
    ->setModules($modules)
    ->setDependencies($dependencies)
    ->addSubscribers();

$sourceMap = $metaDecorator->getSourceMap();
$builder = $metaDecorator->getBuilder();

try {
    foreach ($sourceMap->getFiles() as $file) {
        $builder->buildByPath($file);
    }
} catch (Throwable $e) {
    echo "{$e->getMessage()}\n";
    while ($e = $e->getPrevious()) {
        echo "{$e->getMessage()}\n";
    }

    echo "\n";
}

$targetStreamMap = $metaDecorator->getTargetStreamMap();

try {
    file_put_contents(__DIR__ . '/static-cache.data', json_encode($targetStreamMap->getHashMap(), JSON_THROW_ON_ERROR));
} catch (JsonException $e) {
    echo "{$e->getMessage()}\n";
}
