<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector;

use Symfony\Component\Validator\Constraints as Assert;
use XCartMarketplace\Connector\Request\ARequest;

class Response
{
    /**
     * @var mixed
     */
    private $response;

    /**
     * @var string
     */
    private string $error = '';

    /**
     * Validate config options agains the validation schema and return the list of errors
     *
     * @param Validator $validator Validator object
     *
     * @return string[]
     */
    public function validate(ARequest $request, Validator $validator): array
    {
        if (!is_array($this->response)) {
            return [];
        }

        $schema = $this->isErrorResponse() ? 'getErrorResponseValidationSchema' : 'getResponseValidationSchema';

        return $validator->validate($this->response, $request::{$schema}(), $request->getClass() . 'Response');
    }

    /**
     * Returns true if response is a standard marketplace error (i.e. ['error' => <error code>, 'message' => <error message>])
     *
     * @return bool
     */
    public function isErrorResponse(): bool
    {
        return $this->response && is_array($this->response) && isset($this->response['error']);
    }

    /**
     * @return string
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * Set response
     *
     * @param mixed $response
     */
    public function setResponse($response): void
    {
        $this->response = $response;
    }

    /**
     * Return response error message
     *
     * @return string
     */
    public function getError(): string
    {
        return $this->error;
    }

    /**
     * Set error message
     *
     * @param string $error
     */
    public function setError(string $error): void
    {
        $this->error = $error;
    }
}
