<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class VerifyInstallationList extends ARequest
{
    protected string $target = 'verify_installation_list';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'modules' => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\All([
                    new Assert\Collection([
                        'author'  => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'name'    => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'major'   => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                        'minor'   => new Assert\PositiveOrZero(),
                        'build'   => new Assert\PositiveOrZero(),
                        'enabled' => new Assert\Type(['type' => 'bool']),
                    ]),
                ]),
            ]),

            'addonsToInstall' => new Assert\Required([
                new Assert\Type('array'),
            ]),
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return null;
    }
}
