<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class UpdateSubscription extends ARequest
{
    protected string $target = 'update_subscription';

    /**
     * Flag: true to use cache to store response
     *
     * @var bool
     */
    protected bool $useCache = false;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'action' => new Assert\Choice(['apply', 'cancel']),
                'plan_id' => new Assert\Optional([
                    new Assert\PositiveOrZero(),
                ]),
                'addons' => new Assert\Optional([
                    new Assert\All([
                        new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                    ]),
                ]),
            ],
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'customer_id' => new Assert\Type('string'),
                'plan_id' => new Assert\PositiveOrZero(),
                'addons' => new Assert\All([
                    new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                ]),
            ],
            'allowMissingFields' => true,
        ]);
    }

    /**
     * Get request cache key
     *
     * @return bool
     */
    public function isIgnoreCache(): bool
    {
        return true;
    }
}
