<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class SaveGmvData extends ARequest
{
    protected string $target = 'save_gmv_data';

    /**
     * Flag: true to use cache to store response
     *
     * @var bool
     */
    protected bool $useCache = false;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'gmv_data' => new Assert\Type('string'),
            ],
        ]);
    }

    /**
     * Get request cache key
     *
     * @return bool
     */
    public function isIgnoreCache(): bool
    {
        return true;
    }
}
