<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class RequestForUpgrade extends ARequest
{
    protected string $target = 'request_for_upgrade';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'modules' => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\All([
                    new Assert\Collection([
                        'author' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'name' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
                        'major' => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                        'minor' => new Assert\Regex(['pattern' => '/^\d+\.?(\d+)?$/']),
                    ]),
                ]),
            ]),
        ]);
    }

    /**
     * Get response validation schema
     *
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'isRequestForUpgradeSent' => new Assert\Range(['min' => 0, 'max' => 1]),
        ]);
    }
}
