<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetWaves extends ARequest
{
    protected string $target = 'get_waves';

    protected int $cacheTTL = self::TTL_LONG;

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Type('string'),
        ]);
    }
}
