<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetTokenData extends ARequest
{
    protected string $target = 'get_token_data';

    /**
     * Request cache TTL
     *
     * @var int
     */
    protected int $cacheTTL = 0;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'token' => new Assert\Type('string'),
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'purchase' => new Assert\Optional([ // List of keys
                new Assert\All([
                    new Assert\Type('string'),
                ]),
            ]),
            'prolongation' => new Assert\Optional([ // List of keys
                new Assert\All([
                    new Assert\Type('string'),
                ]),
            ]),
        ]);
    }
}
