<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetSections extends ARequest
{
    protected string $target = 'get_sections';

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'type' => new Assert\Choice(['banner', 'addons', 'templates']),
                'position' => new Assert\PositiveOrZero(),
                'tag' => new Assert\Type('string'),
                'imageURL' => new Assert\Optional([
                    new Assert\Url(),
                ]),
                'addon' => new Assert\Optional([
                    new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                ]),
                'bannerURL' => new Assert\Optional([
                    new Assert\Url(),
                ]),
                'html' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
                'css' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
                'name' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
                'translations' => new Assert\Optional([
                    new Assert\All([
                        new Assert\Collection([
                            'section_name' => new Assert\Type('string'),
                        ]),
                    ]),
                ]),
                'addons' => new Assert\Optional([
                    new Assert\All([
                        new Assert\Collection([
                            'addon' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+-[a-zA-Z0-9_]+/']),
                            'position' => new Assert\PositiveOrZero(),
                        ]),
                    ]),
                ]),
            ]),
        ]);
    }
}
