<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetPaymentMethods extends ARequest
{
    protected string $target = 'get_payment_methods';

    protected int $cacheTTL = self::TTL_LONG;

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return null;
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Collection([
                'service_name' => new Assert\Type('string'),
                'class' => new Assert\Type('string'),
                'type' => new Assert\Type('string'),
                'orderby' => new Assert\Type('int'),
                'adminOrderby' => new Assert\Optional([
                    new Assert\Type('int'),
                ]),
                'predefined' => new Assert\Optional([
                    new Assert\Type('int'),
                    new Assert\Range(['min' => 0, 'max' => 1]),
                ]),
                'enabled' => new Assert\Range(['min' => 0, 'max' => 1]),
                'added' => new Assert\Range(['min' => 0, 'max' => 1]),
                'moduleEnabled' => new Assert\Range(['min' => 0, 'max' => 1]),
                'fromMarketplace' => new Assert\Range(['min' => 0, 'max' => 1]),
                'moduleName' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+_[a-zA-Z0-9_]+/']),
                'iconURL' => new Assert\Url(),
                'modulePageURL' => new Assert\Type('string'),
                'translations' => [
                    new Assert\Type('array'),
                    new Assert\Count(['min' => 0]),
                    new Assert\All([
                        new Assert\Collection([
                            'code' => new Assert\Type('string'),
                            'name' => new Assert\Type('string'),
                            'title' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'description' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'adminDescription' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                            'altAdminDescription' => new Assert\Optional([
                                new Assert\Type('string'),
                            ]),
                        ]),
                    ]),
                ],
                'countries' => [
                    new Assert\Type('array'),
                    new Assert\Count(['min' => 0]),
                    new Assert\All([
                        //new Assert\Country(),
                        new Assert\Type('string'),
                    ]),
                ],
                'exCountries' => [
                    new Assert\Type('array'),
                    new Assert\Count(['min' => 0]),
                    new Assert\All([
                        new Assert\Country(),
                    ]),
                ],
            ]),
        ]);
    }
}
