<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetCorePack extends AGetPack
{
    protected string $target = 'get_core_pack';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'version' => new Assert\Collection([
                'major' => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                'minor' => new Assert\PositiveOrZero(),
                'build' => new Assert\PositiveOrZero(),
            ]),
            'gzipped' => new Assert\Optional([
                new Assert\Range(['min' => 0, 'max' => 1]),
            ]),
        ]);
    }
}
