<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetCoreHash extends ARequest
{
    protected string $target = 'get_core_hash';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'version' => new Assert\Collection([
                'major' => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                'minor' => new Assert\PositiveOrZero(),
                'build' => new Assert\PositiveOrZero(),
            ]),
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']), // md5 hash
            new Assert\Length(['min' => 32, 'max' => 32]),
        ]);
    }
}
