<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetAddonInfo extends ARequest
{
    protected string $target = 'get_addon_info';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'moduleId' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']),
                'key' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
            ],
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'version' => new Assert\Collection([
                'major' => new Assert\Regex(['pattern' => '/^\d+\.\d+$/']),
                'minor' => new Assert\PositiveOrZero(),
                'build' => new Assert\Optional([
                    new Assert\PositiveOrZero(),
                ]),
            ]),
            'author' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
            'name' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]/']),
            'revisionDate' => new Assert\PositiveOrZero(),
            'minorRequiredCoreVersion' => new Assert\PositiveOrZero(),
            'readableAuthor' => new Assert\Type('string'),
            'readableName' => new Assert\Type('string'),
            'moduleId' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']),
            'description' => new Assert\Type('string'),
            'price' => new Assert\PositiveOrZero(),
            'orig_price' => new Assert\Optional([
                new Assert\PositiveOrZero(),
            ]),
            'currency' => new Assert\Currency(),
            'iconURL' => new Assert\Url(),
            'authorPageURL' => new Assert\Url(),
            'authorEmail' => new Assert\Email(),
            'isLanding' => new Assert\Range(['min' => 0, 'max' => 1]),
            'landingPosition' => [
                new Assert\PositiveOrZero(),
            ],
            'pageURL' => new Assert\Url(),
            'rating' => new Assert\Collection([
                'rate' => new Assert\PositiveOrZero(),
                'votesCount' => new Assert\PositiveOrZero(),
            ]),
            'dependencies' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Regex(['pattern' => '/[a-zA-Z0-9_]+\\\\[a-zA-Z0-9_]+/']),
                ]),
            ],
            'downloadCount' => new Assert\PositiveOrZero(),
            'length' => new Assert\PositiveOrZero(),
            'isSystem' => new Assert\Range(['min' => 0, 'max' => 1]),
            'xcn_plan' => new Assert\GreaterThanOrEqual(['value' => -1]),
            'tags' => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
            ]),
            'xbProductId' => new Assert\PositiveOrZero(),
            'private' => new Assert\Range(['min' => 0, 'max' => 1]),
            'wave' => new Assert\GreaterThanOrEqual(['value' => -10]),
            'salesChannelPos' => new Assert\GreaterThanOrEqual(['value' => -1]),
            'listIconURL' => new Assert\Optional([
                new Assert\Url(),
            ]),
            'skin_image' => new Assert\Optional([
                new Assert\Url(),
            ]),
            'skin_list_image' => new Assert\Optional([
                new Assert\Url(),
            ]),
            'has_license' => new Assert\Range(['min' => 0, 'max' => 1]),
            'license' => new Assert\Optional([
                new Assert\Type('string'),
            ]),
            'edition_state' => new Assert\Range(['min' => -1, 'max' => 2]),
            'editions' => [
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Regex(['pattern' => '/[0-9_]+_[a-zA-Z0-9_]+/']),
                ]),
            ],
            'free_for_saas' => new Assert\Optional([
                new Assert\Range(['min' => 0, 'max' => 1]),
            ]),
            'translations' => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
                new Assert\All([
                    new Assert\Collection([
                        'readableName' => new Assert\Type('string'),
                        'descriptions' => new Assert\Type('string'),
                    ]),
                ]),
            ]),
            'docs' => new Assert\Optional([
                new Assert\Type('array'),
                new Assert\Count(['min' => 0]),
            ]),
        ]);
    }
}
