<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints as Assert;

class GetAddonHash extends ARequest
{
    protected string $target = 'get_addon_hash';

    /**
     * @return Constraint|null
     */
    public static function getValidationSchema(): ?Constraint
    {
        return new Assert\Collection([
            'fields' => [
                'moduleId' => new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']),
                'key' => new Assert\Optional([
                    new Assert\Type('string'),
                ]),
            ],
        ]);
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return new Assert\All([
            new Assert\Regex(['pattern' => '/[a-zA-Z0-9]/']), // md5 hash
            new Assert\Length(['min' => 32, 'max' => 32]),
        ]);
    }
}
