<?php

declare(strict_types=1);

namespace XCartMarketplace\Connector\Request;

use Symfony\Component\Validator\Constraint;
use XCartMarketplace\Connector\Validator;

abstract class AGetPack extends ARequest
{
    /**
     * Flag: true to use cache to store response
     *
     * @var bool
     */
    protected bool $useCache = false;

    /**
     * Request timeout (guzzle)
     *
     * @var int
     */
    protected int $timeout = 60;

    /**
     * Validate config options agains the validation schema and return the list of errors
     *
     * @param Validator $validator Validator object
     *
     * @return string[]
     */
    public function validate(Validator $validator): array
    {
        $errors = parent::validate($validator);

        if (
            ($range = ($this->serviceOptions['range'] ?? null))
            && !preg_match('/^\d+-\d+$/', $range)
        ) {
            $errors[] = sprintf('Wrong range format (%s), expected X-Y', $range);
        }

        return $errors;
    }

    /**
     * @return Constraint|null
     */
    public static function getResponseValidationSchema(): ?Constraint
    {
        return null;
    }

    /**
     * Get request headers
     *
     * @return array
     */
    public function getHeaders(): array
    {
        $headers = parent::getHeaders();

        if ($range = ($this->serviceOptions['range'] ?? null)) {
            $headers['Range'] = 'bytes=' . $range;
        }

        return $headers;
    }
}
