<?php

namespace App\Tests\Logic;

use App\Logic\CheckDependencyMap;
use MJS\TopSort\Implementations\StringSort;
use PHPUnit\Framework\TestCase;

class CheckDependencyMapTest extends TestCase
{
    /**
     * @param array $expected
     * @param array $dependencyMap
     *
     * @dataProvider providerGetCycle
     */
    public function testGetCycle(array $expected, array $dependencyMap): void
    {
        $checkDependencyMap = new CheckDependencyMap(new StringSort());

        $this->assertEquals($expected, $checkDependencyMap->getCycle($dependencyMap));
    }

    public function providerGetCycle(): array
    {
        return [
            [['A', 'B'], ['A' => ['B'], 'B' => ['A']]],
            [['A', 'B', 'D'], ['A' => ['B'], 'B' => ['D'], 'D' => ['A']]],
            [['A', 'B', 'D'], ['A' => ['B'], 'B' => ['D'], 'F' => ['A'], 'D' => ['A']]],
            [['A', 'C'], ['A' => ['B', 'C'], 'B' => ['D'], 'C' => ['A'], 'D' => ['E']]],
            [['A', 'B'], ['A' => ['B'], 'B' => ['A'], 'C' => ['D'], 'D' => ['C']]],
        ];
    }
}
