<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Traits;

trait JsonFilterTrait
{
    protected function isJsonProperty(string $property): bool
    {
        return strpos($property, '->') !== false;
    }

    protected function splitJsonProperty(string $property): array
    {
        $pos = strpos($property, '->');

        return [
            substr($property, 0, $pos),
            substr($property, $pos + 2),
        ];
    }
}
