<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Scenario;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Symfony\Component\Uid\UuidV4;

final class ScenarioRepository
{
    private EntityRepository $repository;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->repository = $entityManager->getRepository(Scenario::class);
    }

    public function findById(UuidV4 $scenarioId): ?Scenario
    {
        return $this->repository->find($scenarioId);
    }

    public function findLastScenario(): ?Scenario
    {
        $qb = $this->repository->createQueryBuilder('s');

        $qb
            ->select('s.id')
            ->orderBy('s.date', 'DESC')
            ->setMaxResults(1);

        $id = $qb->getQuery()->execute()[0]['id'] ?? null;

        if ($id) {
            return $this->findById($id);
        }

        return null;
    }
}
