<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Data;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;

final class DataRepository
{
    private EntityManagerInterface $entityManager;

    private EntityRepository $repository;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->entityManager = $entityManager;
        $this->repository    = $entityManager->getRepository(Data::class);
    }

    public function getData(): array
    {
        $result = [];

        /** @var Data $item */
        foreach ($this->repository->findAll() as $item) {
            $result[$item->getName()] = $item->getValue();
        }

        return $result;
    }

    public function setData($name, $value): void
    {
        $data = $this->repository->findOneBy(['name' => $name]);

        if (!$data) {
            $data = new Data();
            $data->setName($name);

            $this->entityManager->persist($data);
        }

        $data->setValue($value);

        $this->entityManager->flush();
    }
}
