<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Output;

use Symfony\Component\Console\Output\OutputInterface;

class XCartConsoleOutput extends XCartBufferedOutput
{
    private OutputInterface $output;

    private bool $isNewLine = true;

    public function setOutput(OutputInterface $output): void
    {
        $this->output = $output;
    }

    public function addInitMessage(string $message): XCartConsoleOutput
    {
        parent::addInitMessage($message);

        $this->output->write($message);
        $this->isNewLine = false;

        return $this;
    }

    public function addEndMessage(string $message): XCartConsoleOutput
    {
        parent::addEndMessage($message);

        if (!$this->isNewLine) {
            $this->output->write(' ');
        }

        $this->output->writeln("<info>$message</info>");
        $this->isNewLine = true;

        return $this;
    }

    public function addErrorMessage(string $message): XCartConsoleOutput
    {
        parent::addErrorMessage($message);

        if (!$this->isNewLine) {
            $this->output->write(' ');
        }

        $this->output->writeln("<error>$message</error>");
        $this->isNewLine = true;

        return $this;
    }
}
