<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Output;

class XCartBufferedOutput implements XCartOutputInterface
{
    private array $buffer = [];

    public function getBufferData(): array
    {
        return $this->buffer;
    }

    public function setBufferData(array $bufferData): void
    {
        $this->buffer = $bufferData;
    }

    public function clearBuffer(): void
    {
        $this->buffer = [];
    }

    private function addToBuffer(string $type, string $message): void
    {
        $this->buffer[] = [
            'type'    => $type,
            'message' => $message,
        ];
    }

    public function addInitMessage(string $message): XCartBufferedOutput
    {
        $this->addToBuffer('common', $message);

        return $this;
    }

    public function addEndMessage(string $message): XCartBufferedOutput
    {
        $this->addToBuffer('info', $message);

        return $this;
    }

    public function addErrorMessage(string $message): XCartBufferedOutput
    {
        $this->addToBuffer('error', $message);

        return $this;
    }
}
