<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Output;

class RuntimeOutput implements XCartOutputInterface
{
    private XCartOutputInterface $consoleOutput;

    private XCartOutputInterface $bufferedOutput;

    public function __construct(
        XCartOutputInterface $consoleOutput,
        XCartOutputInterface $bufferedOutput
    ) {
        $this->consoleOutput = $consoleOutput;
        $this->bufferedOutput = $bufferedOutput;
    }

    public function addInitMessage(string $message): XCartOutputInterface
    {
        return $this->getOutput()->addInitMessage($message);
    }

    public function addEndMessage(string $message): XCartOutputInterface
    {
        return $this->getOutput()->addEndMessage($message);
    }

    public function addErrorMessage(string $message): XCartOutputInterface
    {
        return $this->getOutput()->addErrorMessage($message);
    }

    public function getBufferData(): array
    {
        return $this->getOutput()->getBufferData();
    }

    public function clearBuffer(): void
    {
        $this->getOutput()->clearBuffer();
    }

    private function getOutput(): XCartOutputInterface
    {
        if (PHP_SAPI === 'cli') {
            return $this->consoleOutput;
        }

        return $this->bufferedOutput;
    }
}
