<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\PrepareCode;

use App\Operation\Pack\PackerConfig\PackerConfigInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Finder\SplFileInfo;

final class PrepareModulesCode implements PrepareCodeInterface
{
    private Filesystem $filesystem;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    public function __invoke(PackerConfigInterface $packerConfig): void
    {
        $outputPath = $packerConfig->getOutputPath();

        $this->cleanup($outputPath);
    }

    private function cleanup(string $outputPath): void
    {
        $files = (new Finder())
            ->in("{$outputPath}xcart/")
            ->ignoreDotFiles(false)
            ->path('/^.*\.git.*$/')
            ->filter(static fn (SplFileInfo $item) => strpos($item->getPathname(), '.gitkeep') === false);

        $this->filesystem->remove(array_map(
            static fn (SplFileInfo $item) => $item->getPathname(),
            iterator_to_array($files)
        ));
    }
}
