<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\PackerConfig;

interface PackerConfigInterface
{
    public function getSource(): string;

    public function getSourcePath(): string;

    public function getOutputPath(): string;

    public function getName(): string;

    public function getVersion(): string;

    public function getLanguage(): string;

    public function getModules(): array;

    public function getExternalModules(): array;

    public function getDisabledModules(): array;

    public function getLicenseKey(): string;

    public function getInstallConfiguration(): array;
}
