<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\PackerConfig;

final class PackerConfig implements PackerConfigInterface
{
    private string $source = 'git';

    private string $sourcePath = '';

    private string $outputPath = '';

    private string $name = '';

    private string $version = '';

    private string $language = '';

    private array $modules = [];

    private array $externalModules = [];

    private array $disabledModules = [];

    private string $licenseKey = '';

    private array $installConfiguration = [];

    public function getSource(): string
    {
        return $this->source;
    }

    public function setSource(string $source): PackerConfig
    {
        $this->source = $source;

        return $this;
    }

    public function getSourcePath(): string
    {
        return $this->sourcePath;
    }

    public function setSourcePath(string $sourcePath): PackerConfig
    {
        $this->sourcePath = $sourcePath;

        return $this;
    }

    public function getOutputPath(): string
    {
        return $this->outputPath;
    }

    public function setOutputPath(string $outputPath): PackerConfig
    {
        $this->outputPath = $outputPath;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): PackerConfig
    {
        $this->name = $name;

        return $this;
    }

    public function getVersion(): string
    {
        return $this->version;
    }

    public function setVersion(string $version): PackerConfig
    {
        $this->version = $version;

        return $this;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }

    public function setLanguage(string $language): PackerConfig
    {
        $this->language = $language;

        return $this;
    }

    public function getModules(): array
    {
        return $this->modules;
    }

    public function setModules(array $modules): PackerConfig
    {
        $this->modules = $modules;

        return $this;
    }

    public function getExternalModules(): array
    {
        return $this->externalModules;
    }

    public function setExternalModules(array $modules): PackerConfig
    {
        $this->externalModules = $modules;

        return $this;
    }

    public function getDisabledModules(): array
    {
        return $this->disabledModules;
    }

    public function setDisabledModules(array $modules): PackerConfig
    {
        $this->disabledModules = $modules;

        return $this;
    }

    public function getLicenseKey(): string
    {
        return $this->licenseKey;
    }

    public function setLicenseKey(string $licenseKey): PackerConfig
    {
        $this->licenseKey = $licenseKey;

        return $this;
    }

    public function getInstallConfiguration(): array
    {
        return $this->installConfiguration;
    }

    public function setInstallConfiguration(array $installConfiguration): void
    {
        $this->installConfiguration = $installConfiguration;
    }
}
