<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack;

use App\Operation\Pack\CreatePack\CreatePackInterface;
use App\Operation\Pack\GetCode\GetCodeInterface;
use App\Operation\Pack\Finish\FinishInterface;
use App\Operation\Pack\Init\InitInterface;
use App\Operation\Pack\PackerConfig\PackerConfigInterface;
use App\Operation\Pack\PrepareCode\PrepareCodeInterface;

final class Packer implements PackerInterface
{
    private InitInterface $init;

    private GetCodeInterface $getCode;

    private PrepareCodeInterface $prepareCode;

    private CreatePackInterface $createPack;

    private FinishInterface $finish;

    public function __construct(
        InitInterface $init,
        GetCodeInterface $getCode,
        PrepareCodeInterface $prepareCode,
        CreatePackInterface $createPack,
        FinishInterface $finish
    ) {
        $this->init        = $init;
        $this->getCode     = $getCode;
        $this->prepareCode = $prepareCode;
        $this->createPack  = $createPack;
        $this->finish      = $finish;
    }

    public function pack(PackerConfigInterface $config): array
    {
        ($this->init)($config);
        ($this->getCode)($config);
        ($this->prepareCode)($config);

        $result = ($this->createPack)($config);

        ($this->finish)($config);

        return $result;
    }
}
