<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\Init;

use App\Domain\XCart;
use App\Operation\ExecuteShellCommand;

final class InitTranslationCode
{
    public const TEMPORARY_DATA_SUBFOLDER = 'xcart/';

    public function __construct(
        protected XCart $XCart,
        protected ExecuteShellCommand $executeShellCommand
    ) {
    }

    public function __invoke(string $translationCodeFolder)
    {
        ($this->executeShellCommand)('rm -rf ' . self::TEMPORARY_DATA_SUBFOLDER, $translationCodeFolder);
    }
}
