<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\Init;

use App\Operation\Pack\PackerConfig\PackerConfigInterface;
use Symfony\Component\Filesystem\Filesystem;

final class Init implements InitInterface
{
    private Filesystem $filesystem;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    public function __invoke(PackerConfigInterface $packerConfig): void
    {
        $outputPath = $packerConfig->getOutputPath();

        $this->filesystem->mkdir("{$outputPath}xcart/");
    }
}
