<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\GetCode;

use App\Operation\ExecuteShellCommand;
use SplFileInfo;
use Symfony\Component\Finder\Finder;

final class GetTranslationModuleCode
{
    public function __construct(
        protected ExecuteShellCommand $executeShellCommand
    ) {
    }

    public function __invoke(
        string $boilerplatePath,
        string $dstPath,
        string $temporaryArchivePath
    ): void {
        $excludes = implode(' ', $this->getExcludes($boilerplatePath . '/'));

        ($this->executeShellCommand)(
            $this->executeShellCommand->buildTarCommand("-czf {$temporaryArchivePath} {$excludes} ./"),
            $boilerplatePath
        );

        ($this->executeShellCommand)(
            $this->executeShellCommand->buildTarCommand(
                '-k -xzf ' . $temporaryArchivePath . ' -C ./'
            ),
            $dstPath
        );

        ($this->executeShellCommand)(
            'rm ' . pathinfo($temporaryArchivePath, PATHINFO_BASENAME),
            pathinfo($temporaryArchivePath, PATHINFO_DIRNAME)
        );
    }

    protected function getExcludes(string $path): array
    {
        return array_map(
            static fn (SplFileInfo $file): string => '--exclude=' . substr($file->getPathname(), strlen($path)),
            iterator_to_array(
                (new Finder())->ignoreDotFiles(false)->name([
                    '/^\._/',
                    '/^\.DS_Store/'
                ])->in($path)
            )
        );
    }
}
