<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\GetCode;

use App\Operation\ExecuteShellCommand;
use App\Operation\Pack\PackerConfig\PackerConfigInterface;

final class GetGitModulesCode implements GetCodeInterface
{
    private ExecuteShellCommand $executeShellCommand;

    public function __construct(
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->executeShellCommand = $executeShellCommand;
    }

    public function __invoke(PackerConfigInterface $packerConfig): void
    {
        $sourcePath = $packerConfig->getSourcePath();
        $outputPath = $packerConfig->getOutputPath();
        $modules = $packerConfig->getModules();

        $modules = array_map(static fn ($item) => 'modules/' . str_replace('-', '/', $item), $modules);
        $modules = implode(' ', $modules);
        ($this->executeShellCommand)("git archive --format=tar HEAD {$modules} | gzip > {$outputPath}xcart.tgz", $sourcePath);

        ($this->executeShellCommand)($this->executeShellCommand->buildTarCommand('-xzf xcart.tgz -C ./xcart'), $outputPath);

        ($this->executeShellCommand)('rm -rf xcart.tgz', $outputPath);
    }
}
