<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\GetCode;

use App\Operation\ExecuteShellCommand;
use App\Operation\Pack\PackerConfig\PackerConfigInterface;

final class GetGitCoreCode implements GetCodeInterface
{
    private ExecuteShellCommand $executeShellCommand;

    public function __construct(
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->executeShellCommand = $executeShellCommand;
    }

    public function __invoke(PackerConfigInterface $packerConfig): void
    {
        $sourcePath = $packerConfig->getSourcePath();
        $outputPath = $packerConfig->getOutputPath();

        ($this->executeShellCommand)("git archive --format=tar HEAD | gzip > {$outputPath}service-tool.tgz", "{$sourcePath}service-tool/");
        ($this->executeShellCommand)("git archive --format=tar HEAD | gzip > {$outputPath}xcart.tgz", $sourcePath);

        ($this->executeShellCommand)($this->executeShellCommand->buildTarCommand('-xzf xcart.tgz -C ./xcart'), $outputPath);
        ($this->executeShellCommand)($this->executeShellCommand->buildTarCommand('-xzf service-tool.tgz -C ./xcart/service-tool'), $outputPath);

        ($this->executeShellCommand)('rm -rf xcart.tgz', $outputPath);
        ($this->executeShellCommand)('rm -rf service-tool.tgz', $outputPath);
    }
}
