<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\GetCode;

use Symfony\Component\Filesystem\Filesystem;

final class GetExternalModules
{
    /**
     * @var DownloadExternalModules
     */
    private DownloadExternalModules $downloadPacks;

    /**
     * @var Filesystem
     */
    private Filesystem $filesystem;

    public function __construct(
        DownloadExternalModules $downloadPacks,
        Filesystem $filesystem
    ) {
        $this->downloadPacks = $downloadPacks;
        $this->filesystem    = $filesystem;
    }

    public function __invoke($sourcePath, array $moduleIds, $licenseKey = '')
    {
        if ($licenseKey) {
            $params = ['xcn_license_key' => $licenseKey];
        }

        $paths = ($this->downloadPacks)($moduleIds, $params ?? []);

        foreach ($paths as $moduleId => $path) {
            $moduleDir = str_replace('-', '/', $moduleId);
            $dirFrom   = "{$path}/modules/{$moduleDir}";
            $dirTo     = "{$sourcePath}modules/{$moduleDir}";

            $this->filesystem->mkdir($dirTo);
            $this->filesystem->mirror($dirFrom, $dirTo);
            $this->filesystem->remove($path);
        }
    }
}
