<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\GetCode;

use Symfony\Component\Finder\Finder;

final class GetCustomPaths
{
    private const ZONES = ['admin', 'common', 'customer'];

    protected const INTERFACES = ['web', 'mail', 'pdf'];

    /**
     * @param string $rootPath
     * @param string $localDir
     *
     * @return array
     */
    public function __invoke(string $rootPath, string $localDir): array
    {
        $customFilePaths = [];

        foreach (self::INTERFACES as $interface) {
            foreach (self::ZONES as $zone) {
                $zoneInterfacePath = "{$localDir}/custom_{$interface}/{$zone}";

                $customFiles = (new Finder())
                    ->ignoreDotFiles(false)
                    ->in("{$rootPath}{$zoneInterfacePath}");

                $customFileFullPaths = [];
                foreach ($customFiles as $path) {
                    $customFileFullPaths[] = "./{$zoneInterfacePath}/{$path->getRelativePathname()}";
                }

                $customFilePaths[$zone] = $customFileFullPaths;
            }
        }

        return array_merge(...array_values($customFilePaths));
    }
}
