<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\Finish;

use App\Operation\ExecuteShellCommand;
use App\Operation\Pack\PackerConfig\PackerConfigInterface;

final class Finish implements FinishInterface
{
    private ExecuteShellCommand $executeShellCommand;

    public function __construct(
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->executeShellCommand = $executeShellCommand;
    }

    public function __invoke(PackerConfigInterface $packerConfig): void
    {
        $outputPath = $packerConfig->getOutputPath();

        ($this->executeShellCommand)('rm -rf xcart/', $outputPath);
    }
}
