<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\CreatePack;

trait VersionReplaceTrait
{
    private function setVersion(string $outputPath, string $version): void
    {
        $files = [
            'sql/xlite_data.yaml' => 'xlite_3_0_x',
            'bootstrap.php'   => '5.x',
        ];

        foreach ($files as $file => $pattern) {
            $filePath = "{$outputPath}xcart/{$file}";

            $content = file_get_contents($filePath);
            $content = str_replace($pattern, $version, $content);
            $this->filesystem->dumpFile($filePath, $content);
        }
    }
}
