<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Pack\CreatePack;

use App\Operation\ExecuteShellCommand;
use App\Operation\Pack\PackerConfig\PackerConfigInterface;
use Symfony\Component\Filesystem\Filesystem;

final class CreateDistrPack implements CreatePackInterface
{
    use VersionReplaceTrait;

    private Filesystem $filesystem;

    private ExecuteShellCommand $executeShellCommand;

    public function __construct(
        Filesystem $filesystem,
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->filesystem = $filesystem;
        $this->executeShellCommand = $executeShellCommand;
    }

    public function __invoke(PackerConfigInterface $packerConfig): array
    {
        $outputPath = $packerConfig->getOutputPath();
        $name       = $packerConfig->getName();
        $version    = $packerConfig->getVersion();
        $language   = $packerConfig->getLanguage();

        $this->setVersion($outputPath, $version);

        return [$this->pack($outputPath, $name, $version, $language)];
    }

    private function pack(string $outputPath, string $name, string $version, string $language): string
    {
        $archive = "{$outputPath}x-cart-{$version}-{$name}-{$language}.tar.gz";

        ($this->executeShellCommand)($this->executeShellCommand->buildTarCommand("-czf {$archive} xcart"), $outputPath);

        return $archive;
    }
}
