<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Integrity;

use App\Exception\GetHashException;
use App\Marketplace\MarketplaceClient;
use Symfony\Component\Filesystem\Filesystem;

final class CoreHashRetriever
{
    private MarketplaceClient $client;

    private Filesystem $filesystem;

    public function __construct(
        MarketplaceClient $client,
        Filesystem $filesystem
    ) {
        $this->client = $client;
        $this->filesystem = $filesystem;
    }

    /**
     * @throws GetHashException
     * @throws \JsonException
     */
    public function __invoke(array $coreVersion, $packagePath = null): array
    {
        if ($packagePath && $this->filesystem->exists($packagePath)) {
            $content = file_get_contents("{$packagePath}/.hash");

            return $content ? json_decode($content, true, 512, JSON_THROW_ON_ERROR) : [];
        }

        $response = $this->client->retrieve(
            'get_core_hash',
            ['version' => $coreVersion]
        );

        if (isset($response['error']) || isset($response['code'])) {
            throw GetHashException::fromGetCoreHashResponseWithError($response['message']);
        }

        return $response;
    }
}
