<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Operation\Integrity;

use Symfony\Component\Filesystem\Filesystem;

class ComparedFileRetriever
{
    private Filesystem $filesystem;

    public function __construct(Filesystem $filesystem) {
        $this->filesystem = $filesystem;
    }

    public function __invoke(string $root, array $paths, ?string $moduleId = null): array
    {
        if (!$this->filesystem->exists($root)) {
            return [];
        }

        if ($moduleId !== null) {
            $root = str_replace('modules/' . str_replace('-', '/', $moduleId), '', $root);
        }

        $result = [];
        foreach ($paths as $path) {
            $fullPath = $root . $path;

            if ($this->filesystem->exists($fullPath)) {
                $result[$path] = md5_file($fullPath);
            }
        }

        return $result;
    }
}
