<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Exception\DownloadPackException;
use App\Output\XCartOutputInterface;
use App\Repository\LicenseRepository;

final class XCartOutputDownloader extends AbstractDownloader
{
    private DownloaderInterface $inner;

    private XCartOutputInterface $output;

    public function __construct(
        DownloaderInterface $inner,
        XCartOutputInterface $output,
        ChunkRetrieverInterface $chunkRetriever,
        LicenseRepository $licenseRepository
    ) {
        parent::__construct($licenseRepository, $chunkRetriever);

        $this->inner = $inner;
        $this->output = $output;
    }

    /**
     * @throws DownloadPackException
     */
    public function download(
        string $moduleId,
        array $moduleUpgradeData,
        string $targetPath,
        string $target = '',
        array $params = [],
        int $current = 0,
        int $totalSize = 0
    ): void {
        try {
            $this->output->addInitMessage("Download package {$moduleId}");

            $this->inner->download($moduleId, $moduleUpgradeData, $targetPath, $target, $params, $current);

            $this->output->addEndMessage("[OK]");
            $this->output->addEndMessage("The package is successfully stored at {$targetPath}");

        } catch (DownloadPackException $e) {
            $this->output->addErrorMessage($e->getMessage());

            throw $e;
        }
    }
}
