<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Output\XCartOutputInterface;

final class XCartOutputChunkRetriever implements ChunkRetrieverInterface
{
    private ChunkRetrieverInterface $inner;

    private XCartOutputInterface $output;

    public function __construct(
        ChunkRetrieverInterface $inner,
        XCartOutputInterface $output
    ) {
        $this->inner = $inner;
        $this->output = $output;
    }

    public function retrieveSize(string $target, array $params, string $moduleId): int
    {
        return $this->inner->retrieveSize($target, $params, $moduleId);
    }

    /**
     * @param resource $stream
     */
    public function retrieve(
        $stream,
        string $target,
        array $params,
        string $range,
        string $moduleId
    ): void {
        $this->inner->retrieve($stream, $target, $params, $range, $moduleId);

        $this->output->addInitMessage('.');
    }
}
