<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Exception\DownloadPackException;
use App\Exception\RetrieveSingleChunkException;

final class SingleChunkRetriever extends MarketplaceChunkRetriever
{
    /**
     * @param resource $stream
     *
     * @throws RetrieveSingleChunkException
     * @throws DownloadPackException
     */
    public function retrieve(
        $stream,
        string $target,
        array $params,
        string $range,
        string $moduleId
    ): void {
        parent::retrieve($stream, $target, $params, $range, $moduleId);

        throw new RetrieveSingleChunkException();
    }
}
