<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Exception\DownloadPackException;
use App\Marketplace\MarketplaceClient;

class MarketplaceChunkRetriever implements ChunkRetrieverInterface
{
    private MarketplaceClient $client;

    public function __construct(
        MarketplaceClient $client
    ) {
        $this->client = $client;
    }

    /**
     * @throws DownloadPackException
     */
    public function retrieveSize(string $target, array $params, string $moduleId): int
    {
        $response = $this->client->retrieve($target, $params, true, ['range' => '0-1']);
        $total    = $response['total'] ?? null;

        if (isset($response['error'])) {
            throw DownloadPackException::fromResponseWithError($response['message'], $moduleId);
        }

        if (!$total) {
            throw DownloadPackException::fromEmptyResponse($moduleId);
        }

        return (int) $total;
    }

    /**
     * @param resource $stream
     *
     * @throws DownloadPackException
     */
    public function retrieve(
        $stream,
        string $target,
        array $params,
        string $range,
        string $moduleId
    ): void {
        $response = $this->client->retrieve($target, $params, true, ['range' => $range]);

        if (isset($response['error'])) {
            throw DownloadPackException::fromResponseWithError($response['message'], $moduleId);
        }

        $data = (string) $response['body'];

        fwrite($stream, $data);
    }
}
