<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Exception\DownloadPackException;
use App\Repository\LicenseRepository;
use Psr\Log\LoggerInterface;

final class LoggedDownloader extends AbstractDownloader
{
    private DownloaderInterface $inner;

    private LoggerInterface $logger;

    public function __construct(
        DownloaderInterface $inner,
        LoggerInterface $logger,
        ChunkRetrieverInterface $chunkRetriever,
        LicenseRepository $licenseRepository
    ) {
        parent::__construct($licenseRepository, $chunkRetriever);

        $this->inner = $inner;
        $this->logger = $logger;
    }

    /**
     * @throws DownloadPackException
     */
    public function download(
        string $moduleId,
        array $moduleUpgradeData,
        string $targetPath,
        string $target = '',
        array $params = [],
        int $current = 0,
        int $totalSize = 0
    ): void {
        try {
            $this->inner->download($moduleId, $moduleUpgradeData, $targetPath, $target, $params, $current);
        } catch (DownloadPackException $e) {
            $this->logger->notice($e->getMessage());

            throw $e;
        }
    }
}
