<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

use App\Exception\DownloadPackException;

interface DownloaderInterface
{
    /**
     * @throws DownloadPackException
     */
    public function download(
        string $moduleId,
        array $moduleUpgradeData,
        string $targetPath,
        string $target = '',
        array $params = [],
        int $current = 0,
        int $totalSize = 0
    ): void;

    public function getSize(string $target, array $params, string $moduleId): int;

    public function getTarget(string $moduleId): string;

    public function getParams(string $moduleId, array $moduleUpgradeData): array;
}
