<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Download;

interface ChunkRetrieverInterface
{
    public function retrieveSize(string $target, array $params, string $moduleId): int;

    /**
     * @param resource $stream
     */
    public function retrieve(
        $stream,
        string $target,
        array $params,
        string $range,
        string $moduleId
    ): void;
}
