<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade54To55;

use App\Repository\DataRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\EntityManagerInterface;

final class SetServiceData
{
    private string $tablePrefix;

    private EntityManagerInterface $entityManager;

    private DataRepository $dataRepository;

    public function __construct(
        string $tablePrefix,
        EntityManagerInterface $entityManager,
        DataRepository $dataRepository
    ) {
        $this->tablePrefix    = $tablePrefix;
        $this->entityManager  = $entityManager;
        $this->dataRepository = $dataRepository;
    }

    public function __invoke(): void
    {
        $conn = $this->entityManager->getConnection();

        $locationCountry = $conn->fetchOne(
            "SELECT value FROM {$this->tablePrefix}_config WHERE category = ? AND name = ?",
            ['Company', 'location_country'],
            [Types::STRING, Types::STRING]
        );

        $siteAdministrator = $conn->fetchOne(
            "SELECT value FROM {$this->tablePrefix}_config WHERE category = ? AND name = ?",
            ['Company', 'site_administrator'],
            [Types::STRING, Types::STRING]
        );

        $emails = @unserialize($siteAdministrator, ['allowed_classes' => false]);

        $this->dataRepository->setData('xcart.marketplace.shop-country', $locationCountry ?? '');
        $this->dataRepository->setData('xcart.marketplace.admin-email', $emails[0] ?? '');
    }
}
