<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade54To55;

use App\Domain\XCart;
use Symfony\Component\Filesystem\Filesystem;

final class MovePublicFiles
{
    private string $sourcePath;

    private Filesystem $filesystem;

    public function __construct(
        XCart $XCart,
        Filesystem $filesystem
    ) {
        $this->sourcePath = $XCart->getSourcePath();
        $this->filesystem = $filesystem;
    }

    public function __invoke(): void
    {
        $dirsToMove = ['files', 'images', 'assets'];

        foreach ($dirsToMove as $dir) {
            $this->moveDir($dir);
        }
    }

    private function moveDir($dir): void
    {
        $originDir = "{$this->sourcePath}{$dir}";

        if ($this->filesystem->exists($originDir)) {
            $targetDir = "{$this->sourcePath}public/{$dir}";

            $this->filesystem->mirror($originDir, $targetDir);
        }

    }
}
