<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade54To55;

use App\Exception\GetVersionInfoException;
use App\Marketplace\Marketplace;

final class GetPostUpgradeNotes
{
    private Marketplace $marketplace;

    public function __construct(Marketplace $marketplace) {
        $this->marketplace = $marketplace;
    }

    /**
     * @throws GetVersionInfoException
     */
    public function __invoke(array $transitions): array
    {
        $entities = [];
        foreach ($transitions as $moduleId => $moduleInfo) {
            [$author, $name] = explode('-', $moduleId);
            $entities[] = [
                'author'      => $author,
                'name'        => $name,
                'versionFrom' => $moduleInfo['versionFrom'],
                'versionTo'   => $moduleInfo['versionTo'],
                'infoType'    => ['post_upgrade'],
            ];
        }

        return $this->marketplace->getVersionInfo($entities);
    }
}
